#include "nexgendash.h"
#include <XBApp.h>
#include <XBFont.h>
#include <XBMesh.h>
#include <XBResource.h>
#include <XBUtil.h>
#include <XBSound.h>
//#include <Xmv.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
//#include "Resource.h"
#include "XBFontEx.h"
#include "XBInputEx.h"
#include "XBSoundEx.h"
#include "httpd.h"
#include "httpd-dyncntnt.h"
#include "httpd-filetype.h"
#include "httpd-log.h"
#include "httpd-filehdlr.h"
//#include "wmainmemory.h"
#include "dsstdfx.h"
#include "MusicManager.h"
#include "XKUtils.h"
#include "xkeeprom.h"
#include "ftpclient.h"
#include "Menu.h"

//SoundTracks
// Start of Music Manager
LPDIRECTSOUND8  m_pDSound;          // DirectSound object
CMusicManager*  m_pMusicManager;    // Music Manager

bool g_AudioControl = false;
bool g_WithAudio = false;
//End SoundTracks

MenuList Menu[8];

LPEEPROMDATA EEPROMData=NULL;
BOOL EEPROMData_Enc=FALSE;
XBOX_VERSION xver;

ftp* theFtpConnection=NULL;

int progress=0;
DWORD progressbar=0;
DWORD progressmax=0;
char progressmessage[128]="";

//Screen Capture
int captureNumber = 0;

typedef struct sceneobject_s {
	char *name;
	void *data;
	void (*render)(struct sceneobject_s *obj, int setmaterials);
	void (*destroy)(struct sceneobject_s *obj);
} sceneobject_t;
sceneobject_t sceneobjectlist[128];

typedef struct scenetxr_s {
	char *name;
	LPDIRECT3DTEXTURE8 data;
	int type;
} scenetxr_t;
scenetxr_t scenetxrlist[128];

typedef struct scenefont_s {
	char *name;
	CXBFontEx data;
} scenefont_t;
scenefont_t scenefontlist[32];

typedef struct scenesound_s {
	char *name;
	CXBSound data;
} scenesound_t;
scenesound_t scenesoundlist[32];

#undef OutputDebugString

void OutputDebugString(char* lpOutputString)
{
	if(lpOutputString!=NULL)
		OutputDebugStringA(lpOutputString);
	else
		OutputDebugStringA("Attempt to print from NULL ptr.\n");
}

int DbgPrintf( LPTSTR ptszFormat, ...)
{
    TCHAR tszBuf[MAX_PATH*2];
    va_list arglist;
    int nRes;

    va_start( arglist, ptszFormat );
    nRes = _vsntprintf( tszBuf, sizeof(tszBuf), ptszFormat, arglist );
    OutputDebugString( tszBuf );
    va_end(arglist);

    return nRes;
}

inline WCHAR* lstrdupW(WCHAR* src) {
	int i=(lstrlenW(src)+1)*sizeof(WCHAR);
	WCHAR* dst=(WCHAR *)malloc(i);
	if(dst==NULL) return NULL;
	lstrcpyW(dst, src);
	return dst;
}

inline WCHAR* lstrdupWfromA(char* src) {
	int i=(lstrlen(src)+1)*sizeof(WCHAR);
	WCHAR* dst=(WCHAR *)malloc(i);
	if(dst==NULL) return NULL;
	wsprintfW(dst, L"%S", src);
	return dst;
}

inline char* lstrdupAfromW(const WCHAR* src) {
	int i=(lstrlenW(src)+1)*sizeof(char);
	char* dst=(char *)malloc(i);
	if(dst==NULL) return NULL;
	sprintf(dst, "%S", src);
	return dst;
}

DWORD ReadAFile(char *fn, unsigned char **out) {
	DWORD filesize;
	HANDLE infile = CreateFileA( fn, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL );
	if(infile == INVALID_HANDLE_VALUE) {
		OutputDebugStringA("Could not load ");
		OutputDebugStringA(fn);
		OutputDebugStringA("\n");
		DWORD eno=GetLastError();
		*out=NULL;
		return 0;
	}

	filesize=GetFileSize(infile, NULL);
	*out=(unsigned char*)malloc(filesize+1);
	memset(*out, 0, filesize+1);
	DWORD readin;
	ReadFile( infile, *out, filesize, &readin, NULL );
	CloseHandle( infile );
	return readin;
}

#include "flash.h"
CXBoxFlash g_Flash;
static fci_t *fci=NULL;

extern "C" unsigned char *filedata;
extern "C" DWORD filedata_size;

typedef struct localrsrc_s {
	BYTE*           SysMemData;
	BYTE*           VidMemData;
} localrsrc_t;

localrsrc_t GlobalResources;

typedef struct localmesh_s {
	VOID*           SysMemData;
	VOID*           VidMemData;
	XBMESH_FRAME*   pFrames;
	DWORD           dwNumFrames;
} localmesh_t;

bool showfps=FALSE;
char MyMediaPath[MAX_PATH];

D3DVIEWPORT8 g_ViewPort;
D3DXMATRIX g_matView, g_matProj;

XKUtils m_xkutils;
XKEEPROM m_xkeeprom;

class CXBoxSample : public CXBApplication
{
public:

	//CWMAFileStream			m_Stream;		        // The WMA stream
	//HRESULT					m_hrOpenResult;			// Error code 
    //LPDIRECTSOUND8				m_pDSound;              // DirectSound object
    LPDIRECTSOUNDBUFFER8		m_pDSBuffer;            // DirectSoundBuffer
	//CWMAFileStream      m_WaveStream;   // WMA stream class

    XBIR_REMOTE*			m_IR_Remote;
    XBIR_REMOTE				m_DefaultIR_Remote;

	LPDIRECT3DTEXTURE8      m_pLogoTexture;

	HRESULT Initialize();
    HRESULT ShowLogo();
    HRESULT RenderQuad(  LPDIRECT3DTEXTURE8 pTexture, FLOAT fAlpha );
    HRESULT Render();
    HRESULT FrameMove();

    HRESULT CheckFile(char *buffer);
    HRESULT LoadScene(char *buffer);
    HRESULT LoadDefaults();
    HRESULT LoadNewScene();
    HRESULT UnloadScene();

	HRESULT CXBoxSample::nexgenDoAction(unsigned int action, void *param);

    CXBoxSample();
};

CXBoxSample::CXBoxSample()
            :CXBApplication()
{
    DWORD dwPack = XGetAVPack();
    DWORD dwVideoFlags = XGetVideoFlags();

    // Enable progressive scan if the user has it enabled
	m_d3dpp.BackBufferWidth = 640;
	m_d3dpp.BackBufferHeight = 480;
	m_d3dpp.Flags = (dwVideoFlags & XC_VIDEO_FLAGS_HDTV_480p) ? D3DPRESENTFLAG_PROGRESSIVE : D3DPRESENTFLAG_INTERLACED;

    m_d3dpp.FullScreen_PresentationInterval=D3DPRESENT_INTERVAL_ONE;
	m_d3dpp.MultiSampleType=D3DMULTISAMPLE_4_SAMPLES_MULTISAMPLE_GAUSSIAN;

}

LPDIRECT3DTEXTURE8 LoadTextureFromXPR(const char *xprfile) {
	HANDLE tifile;

    BYTE *					m_pbHeaders;            // Header memory
    DWORD					m_cbHeaders;            // Count of bytes of resource headers
    BYTE *					m_pbData;               // Texture data memory
    DWORD					m_cbData;               // Count of bytes of data
    XPR_HEADER				xprh;
	DWORD					cb;

	if(xprfile==NULL) return NULL;

	tifile=CreateFile( xprfile, GENERIC_READ, FILE_SHARE_READ, NULL, 
                           OPEN_EXISTING, 0, NULL );
	
	if(tifile==INVALID_HANDLE_VALUE) {
		OutputDebugStringA("Could not open texture ");
		OutputDebugStringA(xprfile);
		OutputDebugStringA(" for reading.\n");
		return NULL;
	}

    if( !ReadFile( tifile, &xprh, sizeof( XPR_HEADER), &cb, NULL ) )
		goto Crapout;
    if( xprh.dwMagic != XPR_MAGIC_VALUE )
		goto Crapout;

    // Allocate memory for the headers
    m_cbHeaders=xprh.dwHeaderSize - 3 * sizeof( DWORD );
    m_pbHeaders=new BYTE[m_cbHeaders];
    if( !m_pbHeaders )
		goto Crapout;

    if( !ReadFile( tifile, m_pbHeaders, m_cbHeaders, &cb, NULL ) )
		goto Crapout;

    // Allocate contiguous memory for the texture data
    m_cbData=xprh.dwTotalSize - xprh.dwHeaderSize;
    m_pbData=(BYTE *)D3D_AllocContiguousMemory( m_cbData, D3DTEXTURE_ALIGNMENT );
    if( !m_pbData )
		goto Crapout;

    // Start the read of the texture data
	SetFilePointer(tifile, xprh.dwHeaderSize, NULL, FILE_BEGIN);
    if( !ReadFile( tifile, m_pbData, m_cbData, &cb, NULL ) )
		goto Crapout;

    BYTE * pbCurrent;
    LPDIRECT3DRESOURCE8 ppResource;

    // Loop over resources, calling Register()
    pbCurrent=m_pbHeaders;

    DWORD type=*((DWORD *)pbCurrent) & D3DCOMMON_TYPE_MASK;

    if((type != D3DCOMMON_TYPE_VERTEXBUFFER) &&
       (type != D3DCOMMON_TYPE_TEXTURE) &&
       (type != D3DCOMMON_TYPE_INDEXBUFFER))
		goto Crapout;
        
    ppResource=(LPDIRECT3DRESOURCE8)pbCurrent;
//    m_dwType=type;
//    pbCurrent += XBResource_SizeOf( ppResource );

    // Index Buffers should not be Register()'d
    if( type != D3DCOMMON_TYPE_INDEXBUFFER )
        ppResource->Register( m_pbData );

    CloseHandle( tifile );
    tifile=INVALID_HANDLE_VALUE;

	LPDIRECT3DTEXTURE8 ppTexture=(LPDIRECT3DTEXTURE8)ppResource;

    return ppTexture;

Crapout:
	OutputDebugStringA("Could not read ");
	OutputDebugStringA(xprfile);
	OutputDebugStringA("\n");
    CloseHandle( tifile );
	return NULL;
}

inline DWORD fread(void *dst, int cnta, int cntb, HANDLE src) {
	DWORD readin=0;
	ReadFile( src, dst, cnta*cntb, &readin, NULL );
	return readin;
}

inline int matchext( char *file, char *ext ) {
	char *ref = strrchr(file, '.');
	ref++;
	return (!strcmp(ref,ext));
}

HRESULT LoadXBGFile( const char * strMeshFilename , localmesh_t * Mesh)
{
	unsigned long fptr=0;

	if(strMeshFilename==NULL) return E_FAIL;

	HANDLE file=CreateFile( strMeshFilename, GENERIC_READ, FILE_SHARE_READ, NULL, 
                           OPEN_EXISTING, 0, NULL );


	if(file==INVALID_HANDLE_VALUE) {
		OutputDebugStringA("Could not open mesh ");
		OutputDebugStringA(strMeshFilename);
		OutputDebugStringA(" for reading.\n");
        return E_FAIL;
    }

    // Read the magic number
    DWORD dwFileID;
    fread( &dwFileID, 1, sizeof(DWORD), file ); 

    if( dwFileID != XBG_FILE_ID )
    {
        DbgPrintf( "ERROR: Invalid XBG file type on file %s!\n", strMeshFilename );
        return E_FAIL;
    }

    // Read in header
    DWORD dwNumFrames;  // Number of mesh frames in the file
    DWORD dwSysMemSize; // Num bytes needed for system memory objects
    DWORD dwVidMemSize; // Num bytes needed for video memory objects

    fread( &dwNumFrames,  1, sizeof(DWORD), file );
    fread( &dwSysMemSize, 1, sizeof(DWORD), file );
    fread( &dwVidMemSize, 1, sizeof(DWORD), file );

    // Read in system memory objects
    Mesh->SysMemData=(VOID*)new BYTE[dwSysMemSize];
    fread( Mesh->SysMemData, dwSysMemSize, 1, file );

    // Read in video memory objects
    Mesh->VidMemData=D3D_AllocContiguousMemory( dwVidMemSize, D3DVERTEXBUFFER_ALIGNMENT );
    fread( Mesh->VidMemData, dwVidMemSize, 1, file ); 
    
    // Now we need to patch the mesh data. Any pointers read from the file were
    // stored as file offsets. So, we simply need to add a base address to patch
    // things up.
    Mesh->pFrames=(XBMESH_FRAME*)Mesh->SysMemData;
    Mesh->dwNumFrames=dwNumFrames;

    for( DWORD i=0; i<Mesh->dwNumFrames; i++ )
    {
        XBMESH_FRAME* pFrame=&Mesh->pFrames[i];
        XBMESH_DATA*  pMesh =&Mesh->pFrames[i].m_MeshData;

        if( pFrame->m_pChild )
            pFrame->m_pChild =(XBMESH_FRAME*)( (DWORD)pFrame->m_pChild - 16 + (DWORD)Mesh->pFrames );
        if( pFrame->m_pNext )
            pFrame->m_pNext  =(XBMESH_FRAME*)( (DWORD)pFrame->m_pNext  - 16 + (DWORD)Mesh->pFrames );
        if( pMesh->m_pSubsets )
            pMesh->m_pSubsets=(XBMESH_SUBSET*)( (DWORD)pMesh->m_pSubsets - 16 + (DWORD)Mesh->pFrames);
        
        if( pMesh->m_dwNumIndices )
            pMesh->m_IB.Data =pMesh->m_IB.Data - 16 + (DWORD)Mesh->pFrames;
        if( pMesh->m_dwNumVertices )
            pMesh->m_VB.Register( Mesh->VidMemData );
    }

    // Finally, create any textures used by the meshes' subsets. In this 
    // implementation, we are pulling textures out of the global resource.
    for( DWORD i=0; i<Mesh->dwNumFrames; i++ )
    {
        XBMESH_DATA* pMesh=&Mesh->pFrames[i].m_MeshData;
        for( DWORD j=0; j < pMesh->m_dwNumSubsets; j++ )
        {
            XBMESH_SUBSET* pSubset=&pMesh->m_pSubsets[j];
			if(pSubset->strTexture!=NULL && strlen(pSubset->strTexture)>0) {
				char tmpstr[MAX_PATH];
				strcpy(tmpstr, strMeshFilename);
				char *tp=strrchr(tmpstr, '\\')+1;

#if 0
				if(tp!=NULL) {
					strcpy(tp, pSubset->strTexture);
					if(matchext(pSubset->strTexture,"xpr") || matchext(pSubset->strTexture,"xbx")) {
						pSubset->pTexture=(LPDIRECT3DTEXTURE8)LoadTextureFromXPR( tmpstr );
					} else if(matchext(pSubset->strTexture,"bmp")) {
						if(D3DXCreateTextureFromFileA(g_pd3dDevice, tmpstr, &pSubset->pTexture)!=S_OK)
							DbgPrintf("Unable to open texture %s\n", tmpstr);
					}
					pSubset->pTexture
				}
#endif

				if(tp!=NULL) {
					strcpy(tp, pSubset->strTexture);
					for(i=0; i<128; i++) {
						if(scenetxrlist[i].name==NULL) {
							DbgPrintf("Texture Slot %i = %s\n", i, tmpstr);
							scenetxrlist[i].name=strdup(tp);
							if(matchext(tmpstr,"xpr") || matchext(tmpstr,"xbx")) {
								scenetxrlist[i].data=(LPDIRECT3DTEXTURE8)LoadTextureFromXPR( tmpstr );
								scenetxrlist[i].type=1;
							} else if(matchext(tmpstr,"bmp")) {
								if(D3DXCreateTextureFromFileA(g_pd3dDevice, tmpstr, &(scenetxrlist[i].data))!=S_OK)
									DbgPrintf("Unable to open texture %s\n", tmpstr);
								scenetxrlist[i].type=0;
							}
							pSubset->pTexture=scenetxrlist[i].data;
							i=128;
						}
					}
				}
			}
        }
    }

	CloseHandle(file);

    return S_OK;
}

float frand() {
	double rn=(double)rand();
	rn/=RAND_MAX*0.5f;
	rn-=1.0f;
	return(float)rn;
}

inline BOOL FileExists(LPCTSTR lpszFileName, BOOL bIsDirCheck) {
	if(lpszFileName != NULL) {
		HANDLE tfile=CreateFile(lpszFileName, 0, 0, NULL, OPEN_EXISTING, bIsDirCheck ? FILE_FLAG_BACKUP_SEMANTICS : 0, NULL);
		if(tfile != INVALID_HANDLE_VALUE) {
			CloseHandle(tfile);
			return TRUE;
		}
		return FALSE;
	}
	return FALSE;
}


HRESULT CXBoxSample::Initialize()
{
	HRESULT hr;
	struct fileHdrStruct fhdr;

	for(int i=0; i<128; i++) {
		sceneobjectlist[i].name=NULL;
		scenetxrlist[i].name=NULL;
	}
	for(int i=0; i<32; i++) {
		scenefontlist[i].name=NULL;
		scenesoundlist[i].name=NULL;
	}

	m_xkutils.DVDDisableEjectReset();

	EEPROMData=(LPEEPROMDATA)malloc(sizeof(EEPROMDATA));
	m_xkeeprom.ReadFromXBOX();
	xver=m_xkeeprom.GetXBOXVersion();
	EEPROMData_Enc=m_xkeeprom.IsEncrypted();
	m_xkeeprom.GetEEPROMData(EEPROMData);
	
	XSetFileCacheSize(2048*1024);

	HANDLE fd_handle = XGetSectionHandle("EFSA");
	if(fd_handle==INVALID_HANDLE_VALUE) {
		return GetLastError();
	} else {
	    filedata=(unsigned char *) XLoadSectionByHandle(fd_handle);
		filedata_size=XGetSectionSize(fd_handle);
	}

	// determine path launch data page	
	resetpaths();
	sprintf(MyMediaPath,"D:");

	XBUtil_SetMediaPath(MyMediaPath);

    // Create a font
    if( FAILED( scenefontlist[0].data.CreateFromEFS( "/font.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;
	else 
		scenefontlist[0].name = strdup("mainfont");
	if( FAILED( scenefontlist[1].data.CreateFromEFS( "/titlefont.xpr" ) ) )
        return XBAPPERR_MEDIANOTFOUND;
	else 
		scenefontlist[1].name = strdup("titlefont");

	// Start of SWolstens music Manager
	if( FAILED( DirectSoundCreate( NULL, &m_pDSound, NULL ) ) )
    return E_FAIL;
	
	DSEFFECTIMAGELOC EffectLoc;
    EffectLoc.dwI3DL2ReverbIndex = I3DL2_CHAIN_I3DL2_REVERB;
    EffectLoc.dwCrosstalkIndex   = I3DL2_CHAIN_XTALK;

    // Create MusicManager
	// This will need a quick re-write for audio checks etc..
	// Will need to get our musicmanager updated 1st.
	m_pMusicManager = new CMusicManager();
	if( m_pMusicManager )
	{
		// Initialize it
//		if ( g_MenuInfo.m_bUseMusicManager )
//		{
			if( FAILED( m_pMusicManager->Initialize(true) ) )
			{
				delete m_pMusicManager;
				m_pMusicManager = NULL;
			}
//		}
	}

	// check to insure there's music. If not, don't use the soundtrack feature at all!!!
//		if ( g_MenuInfo.m_bUseMusicManager &&
//			 ( m_pMusicManager->GetSongCount() == 0 ) )
	if ( m_pMusicManager->GetSongCount() == 0 )
		{
			//g_MenuInfo.m_bUseMusicManager = FALSE;
		}
		else
		{
			//if ( g_MenuInfo.m_bUseMusicManager )
			//{
				//m_pMusicManager->SetRandom(g_MenuInfo.m_bRandomMusic);
				//m_pMusicManager->SetGlobal(g_MenuInfo.m_bGlobalMusic);
				m_pMusicManager->SelectSoundtrack(0);
				m_pMusicManager->SelectSong(0);
//				m_pMusicManager->Play();
			//}
		}
	//}
//	else
//	{
		//g_MenuInfo.m_bUseMusicManager = FALSE;
//	}

	////////////
    //m_pMusicManager = new CMusicManager();
    //if( !m_pMusicManager )
      //  return E_OUTOFMEMORY;

    // Initialize MusicManager
    //if( FAILED( m_pMusicManager->Initialize() ) )
       //return E_FAIL;
	// Initialize MusicManager
   		/*if( FAILED( m_pMusicManager->Initialize() ) )
        	g_WithAudio = false;
		else
			g_WithAudio = true;*/
	//End SoundTracks

	// Create DirectSound
    if( FAILED( DirectSoundCreate( NULL, &m_pDSound, NULL ) ) )
        return E_FAIL;

	//XBOX Music Manager Start Swolsten.

	// We don't give a shit about it but we gotta initialize 3d sound anyway
	DirectSoundUseLightHRTF();

    // download the standard DirectSound effects image
	if( !lookupFilename("/dsstdfx.bin", &fhdr) )
		return E_FAIL;
	//else if( FAILED( m_DSPImage.LoadFromMem( filedata+fhdr.fileStart, fhdr.size ) ) )
//		return E_FAIL;
//	else if( FAILED( m_DSPImage.DownloadImage(m_pDSound) ) )
//		return E_FAIL;


	g_Flash.AddFCI(0x01,0xd5,L"AMD - Am29F080B",0x100000);
	g_Flash.AddFCI(0x04,0xd5,L"FUJITSU - MBM29F080A",0x100000);
	g_Flash.AddFCI(0xad,0xd5,L"Hynix - HY29F080",0x100000);
	g_Flash.AddFCI(0x20,0xf1,L"ST - M29F080A",0x100000);
	g_Flash.AddFCI(0x37,0x8c,L"AMIC - A29002",0x40000);
	g_Flash.AddFCI(0xbf,0x61,L"SST - 49LF020",0x40000);

	//NEW Flash Chips
	//Added By SpOoK
	//Commented out untill checked
	/*g_Flash.AddFCI(0x01,0x5b,L"AMD - Am29LV800B",0x100000);
	g_Flash.AddFCI(0x01,0xda,L"AMD - Am29LV800B",0x100000);
	g_Flash.AddFCI(0x89,0xa6,L"SHARP - LH28F008SCT",0x100000,0x20,0xd0,0x10);*/
	//End New Flash Chips

	{
		fci=g_Flash.CheckID();
		if(fci!=NULL) {
			OutputDebugString("Found compatible flashrom: ");
			OutputDebugStringW(fci->text);
			OutputDebugString("\n");
		} else {
			OutputDebugString("Could not find compatible flashrom.\n");
		}
	}

	XFreeSection("EFSA");

	LoadDefaults();
    filedata_size=ReadAFile("DATA:\\nexgenhttp.dat", &filedata);

	network_init();

    if( FAILED( hr=XBInput_CreateIR_Remotes( &m_IR_Remote ) ) )
    {
        return hr;
    }

	theFtpConnection = new ftp();

    return S_OK;
}


void MakeWorldMatrix( D3DXMATRIX* pMatWorld, float xPos, float yPos, float zPos, float Pitch, float Yaw, float Roll )
{
    D3DXMATRIX MatTemp;  // Temp matrix for rotations.
    D3DXMATRIX MatRot;   // Final rotation matrix, applied to 
                         // pMatWorld.
 
    // Using the left-to-right order of matrix concatenation,
    // apply the translation to the object's world position
    // before applying the rotations.
    D3DXMatrixTranslation(pMatWorld, xPos, yPos, zPos);
    D3DXMatrixIdentity(&MatRot);

    // Now, apply the orientation variables to the world matrix
    if(Pitch || Yaw || Roll) {
        // Produce and combine the rotation matrices.
        D3DXMatrixRotationX(&MatTemp, Pitch);         // Pitch
        D3DXMatrixMultiply(&MatRot, &MatRot, &MatTemp);
        D3DXMatrixRotationY(&MatTemp, Yaw);           // Yaw
        D3DXMatrixMultiply(&MatRot, &MatRot, &MatTemp);
        D3DXMatrixRotationZ(&MatTemp, Roll);          // Roll
        D3DXMatrixMultiply(&MatRot, &MatRot, &MatTemp);
 
        // Apply the rotation matrices to complete the world matrix.
        D3DXMatrixMultiply(pMatWorld, &MatRot, pMatWorld);
    }
}

void MakeWorldScaleMatrix( D3DXMATRIX* pMatWorld, float xPos, float yPos, float zPos, 
	float xSize, float ySize, float zSize, float Pitch, float Yaw, float Roll )
{
    D3DXMATRIX MatTemp;  // Temp matrix for rotations.
    D3DXMATRIX MatRot;   // Final rotation matrix, applied to 
                         // pMatWorld.
 
    // Using the left-to-right order of matrix concatenation,
    // apply the translation to the object's world position
    // before applying the rotations.
    D3DXMatrixTranslation(pMatWorld, xPos, yPos, zPos);
    D3DXMatrixIdentity(&MatRot);

	D3DXMatrixScaling(&MatTemp, xSize, ySize, zSize);
	D3DXMatrixMultiply(pMatWorld, &MatTemp, pMatWorld);
    
	// Now, apply the orientation variables to the world matrix
    if(Pitch || Yaw || Roll) {
        // Produce and combine the rotation matrices.
        D3DXMatrixRotationX(&MatTemp, Pitch);         // Pitch
        D3DXMatrixMultiply(&MatRot, &MatRot, &MatTemp);
        D3DXMatrixRotationY(&MatTemp, Yaw);           // Yaw
        D3DXMatrixMultiply(&MatRot, &MatRot, &MatTemp);
        D3DXMatrixRotationZ(&MatTemp, Roll);          // Roll
        D3DXMatrixMultiply(&MatRot, &MatRot, &MatTemp);
        // Apply the rotation matrices to complete the world matrix.
        D3DXMatrixMultiply(pMatWorld, &MatRot, pMatWorld);
    }
}

VOID SetupMatrices()
{
    // For our world matrix, we will just leave it as the identity
    D3DXMATRIX matWorld;
	//D3DXMatrixIdentity( &matWorld );
	D3DXMatrixScaling(&matWorld, 0.05f, 0.05f, 0.05f);
    g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

    // Set up our view matrix. A view matrix can be defined given an eye point,
    // a point to lookat, and a direction for which way is up. Here, we set the
    // eye five units back along the z-axis and up three units, look at the 
    // origin, and define "up" to be in the y-direction.
    D3DXMatrixLookAtLH( &g_matView, &D3DXVECTOR3( 0.0f, 0.0f, -1.5f ), 
                                  &D3DXVECTOR3( 0.0f, 0.0f, 35.0f ), 
                                  &D3DXVECTOR3( 0.0f, 1.0f, 0.0f ) );
    g_pd3dDevice->SetTransform( D3DTS_VIEW, &g_matView );

    // For the projection matrix, we set up a perspective transform (which
    // transforms geometry from 3D view space to 2D viewport space, with
    // a perspective divide making objects smaller in the distance). To build
    // a perspective transform, we need the field of view (1/4 pi is common),
    // the aspect ratio, and the near and far clipping planes (which define at
    // what distances geometry should be no longer be rendered).
    D3DXMatrixPerspectiveFovLH( &g_matProj, D3DX_PI/2.0f, 4.0f/3.0f, 1.0f, 100.0f );
    g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &g_matProj );

	g_pd3dDevice->GetViewport( &g_ViewPort );
}


HRESULT RenderMesh( LPDIRECT3DDEVICE8 pd3dDevice, XBMESH_DATA* pMesh, int setmaterials )
{
    if( pMesh->m_dwNumVertices == 0 )
        return S_OK;

    // Set the vertex stream
    pd3dDevice->SetStreamSource( 0, &pMesh->m_VB, pMesh->m_dwVertexSize );
    pd3dDevice->SetIndices( &pMesh->m_IB, 0 );

    // Set the FVF code, unless the user asked us not to
    pd3dDevice->SetVertexShader( pMesh->m_dwFVF );

    // Render the subsets
    for( DWORD i=0; i < pMesh->m_dwNumSubsets; i++ )
    {
		if(setmaterials) {
	        // Set the material
		    pd3dDevice->SetMaterial( &pMesh->m_pSubsets[i].mtrl );

			// Set the texture.
			pd3dDevice->SetTexture( 0, pMesh->m_pSubsets[i].pTexture );
		}

        // Draw the mesh subset
        if( D3DPT_TRIANGLESTRIP == pMesh->m_dwPrimType )
            pd3dDevice->DrawIndexedPrimitive( pMesh->m_dwPrimType, 0, 
                                              pMesh->m_pSubsets[i].dwIndexCount,
                                              pMesh->m_pSubsets[i].dwIndexStart, 
                                              pMesh->m_pSubsets[i].dwIndexCount-2 );
        else // D3DPT_TRIANGLELIST
            pd3dDevice->DrawIndexedPrimitive( pMesh->m_dwPrimType, 0, 
                                              pMesh->m_pSubsets[i].dwIndexCount,
                                              pMesh->m_pSubsets[i].dwIndexStart, 
                                              pMesh->m_pSubsets[i].dwIndexCount/3 );
    }

    return S_OK;
}


HRESULT RenderFrame( LPDIRECT3DDEVICE8 pd3dDevice, XBMESH_FRAME* pFrame, int setmaterials )
{
    // Apply the frame's local transform
    D3DXMATRIX matSavedWorld, matWorld;
    pd3dDevice->GetTransform( D3DTS_WORLD, &matSavedWorld );

	D3DXMatrixMultiply( &matWorld, &pFrame->m_matTransform, &matSavedWorld );
	pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );

	// Render the mesh data
	if( pFrame->m_MeshData.m_dwNumSubsets ) 
		RenderMesh( pd3dDevice, &pFrame->m_MeshData, setmaterials );

    // Render any child frames
	if( pFrame->m_pChild ) 
		RenderFrame( pd3dDevice, pFrame->m_pChild, setmaterials );

    // Restore the transformation matrix
	pd3dDevice->SetTransform( D3DTS_WORLD, &matSavedWorld );
    
    // Render any sibling frames
	if( pFrame->m_pNext )  
		RenderFrame( pd3dDevice, pFrame->m_pNext, setmaterials );

    return S_OK;
}


VOID SetupLights()
{
    // Set up a material. The material here just has the diffuse and ambient
    // colors set to white. Note that only one material can be used at a time.
    D3DMATERIAL8 mtrl;
    ZeroMemory( &mtrl, sizeof(D3DMATERIAL8) );
    mtrl.Diffuse.r=mtrl.Ambient.r=1.0f;
    mtrl.Diffuse.g=mtrl.Ambient.g=1.0f;
    mtrl.Diffuse.b=mtrl.Ambient.b=1.0f;
    mtrl.Diffuse.a=mtrl.Ambient.a=1.0f;
    g_pd3dDevice->SetMaterial( &mtrl );

    // The light structure
    D3DLIGHT8 light;
    ZeroMemory( &light, sizeof(D3DLIGHT8) );
    light.Type			= D3DLIGHT_POINT;
	light.Position.z	= 0.0f;
    light.Range			= 5000.0f;
	light.Attenuation0	= 1.0f;
    light.Diffuse.r		= 1.0f;
    light.Diffuse.g		= 1.0f;
    light.Diffuse.b		= 1.0f;
    light.Specular.r	= 1.0f;
    light.Specular.g	= 1.0f;
    light.Specular.b	= 1.0f;
    g_pd3dDevice->SetLight( 0, &light );
    g_pd3dDevice->LightEnable( 0, TRUE );

    light.Diffuse.r		= 2.0f;
    light.Diffuse.g		= 2.0f;
    light.Diffuse.b		= 2.0f;
    light.Specular.r	= 2.0f;
    light.Specular.g	= 2.0f;
    light.Specular.b	= 2.0f;
    g_pd3dDevice->LightEnable( 1, FALSE );

	light.Position.z	= 35.0f;
    light.Diffuse.r		= 3.0f;
    light.Diffuse.g		= 3.0f;
    light.Diffuse.b		= 3.0f;
    light.Specular.r	= 3.0f;
    light.Specular.g	= 3.0f;
    light.Specular.b	= 3.0f;
    g_pd3dDevice->SetLight( 2, &light );
    g_pd3dDevice->LightEnable( 2, FALSE );
}

HRESULT LaunchMyXBE(char * XBEFile, PLAUNCH_DATA LDATA)
{
	HRESULT r;
	char *umFilename, *mFilename, *mDrivePath, *mDriveLetter, *mFullPath, *mDevicePath;

	umFilename=(char*)malloc(strlen(XBEFile)+1);
	lstrcpy(umFilename, XBEFile);
	mFilename=FileFromFilePathA(umFilename);
	mDrivePath=PathFromFilePathA(umFilename);

	int tm=0;
	while(mDrivePath[tm]!=':' && mDrivePath[tm]!=0) tm++;
	mDriveLetter=(char *)malloc(tm+3);
	lstrcpyn(mDriveLetter,mDrivePath, tm+2);
	mDriveLetter[tm+3]=0;
	mDrivePath+=tm+1;
	mDevicePath=getpath(mDriveLetter);
	mFullPath=(char*)malloc(strlen(mDevicePath)+strlen(mDrivePath)+1);
	sprintf(mFullPath, "%s%s", mDevicePath, mDrivePath);
	if(mFullPath[(strlen(mFullPath)-1)]=='\\')
		mFullPath[(strlen(mFullPath)-1)]=0;
	OutputDebugStringA("Mapping ");
	OutputDebugStringA(mFullPath);
	OutputDebugStringA(" to D:\n");
	mappath(mFullPath, "\\??\\D:");
	OutputDebugStringA("Launching ");
	OutputDebugStringA(mFullPath);
	OutputDebugStringA("\\");
	OutputDebugStringA(mFilename);
	OutputDebugStringA("\n");
	mFullPath=(char*)malloc(strlen(mFilename)+4);
	sprintf(mFullPath, "D:\\%s", mFilename);
	r=XLaunchNewImage(mFullPath, (PLAUNCH_DATA)&LDATA);
//	free(umFilename);
//	free(mDriveLetter);
//	free(mFullPath);
	return r;
}

HRESULT XBUtil_CaptureScreen(LPDIRECT3DDEVICE8 pDevice, char cPath[])
{
IDirect3DSurface8 *pFrontBuffer;
pDevice->GetBackBuffer(-1,D3DBACKBUFFER_TYPE_MONO,&pFrontBuffer);
return XGWriteSurfaceToFile(pFrontBuffer, cPath);
}

void systemScreenCapture(int a)
{
  char buffer[2048];

  sprintf(buffer, "STORAGE:\\nexgensd%02d.bmp", a);
  XBUtil_CaptureScreen(g_pd3dDevice, buffer);
}

/*
HRESULT CXBoxSample::nexgenDoAction(unsigned int action, void *param)
{
    if(action == Launch) {
		if(param!=NULL) {
			char * cparam=(char *)malloc(lstrlenW((WCHAR*)param)+1);

			wsprintf(cparam, "%ls", (WCHAR*)param);
			LaunchMyXBE(cparam,NULL);

			free(cparam);
		}
	} else {
		char * cparam;
		switch(action) {
		case Special_Format:
			formatdriveletter((WCHAR *)param);
			break;
		case Special_ReadEEPROM:
			cparam=(char *)malloc(lstrlenW((WCHAR*)param)+1);
			wsprintf(cparam, "%ls", (WCHAR*)param);
			BackupEEPROM( cparam );
			break;
		case Special_WriteEEPROM:
			cparam=(char *)malloc(lstrlenW((WCHAR*)param)+1);
			wsprintf(cparam, "%ls", (WCHAR*)param);
			RestoreEEPROM( cparam );
			break;
		case Special_Eject:
			pic_Eject(1);
			break;
		case Special_Close:
			pic_Eject(0);
			break;
		case Special_Reboot:
			pic_DoReset(0);
			break;
		case Special_PowerOff:
			pic_PowerOff();
			break;
		}
	}

	return S_OK;
}*/

static int keyboardInitDone=0;
static int timeblah=0;


D3DXMATRIX matWorld, matObject, matSavedWorld, matOriginalWorld;

extern "C" {
#include "lua.h"
#include "lualib.h"
};


lua_State *LUA_STATE;

void rendersceneobj_frame(struct sceneobject_s *sobj, int setmaterials)
{
	if(sobj->data!=NULL) {
		localmesh_t *obj=(localmesh_t*) sobj->data;
		RenderFrame( g_pd3dDevice, obj->pFrames, setmaterials );
	}
}

void destroysceneobj_frame(struct sceneobject_s *sobj)
{
	if( sobj->name )
		free(sobj->name);
	sobj->name=NULL;
	sobj->render=NULL;
	sobj->destroy=NULL;

	if( sobj->data ) {
		localmesh_t *obj=(localmesh_t*) sobj->data;
		// Free textures
#if 0
		for( DWORD i=0; i<obj->dwNumFrames; i++ )
		{
			if(obj->pFrames!=0xcdcdcdcd)
			for( DWORD j = 0; j < obj->pFrames[i].m_MeshData.m_dwNumSubsets; j++ )
	        {
		        SAFE_RELEASE( obj->pFrames[i].m_MeshData.m_pSubsets[j].pTexture );
			}
	    }
#endif
		// Free allocated memory - Doesnt work for unknown reason
	    //SAFE_DELETE_ARRAY( obj->SysMemData );

		if( obj->VidMemData )
			D3D_FreeContiguousMemory( obj->VidMemData );
		free(obj);
	}

	sobj->data=NULL;
}

void rendersceneobj_subset(struct sceneobject_s *sobj, int setmaterials)
{
	if(sobj->data!=NULL) {
		LPD3DXMESH obj=(LPD3DXMESH) sobj->data;
		if(setmaterials) {
			D3DMATERIAL8 mtrl;
			ZeroMemory( &mtrl, sizeof(D3DMATERIAL8) );
			mtrl.Diffuse.r=mtrl.Ambient.r=1.0f;
			mtrl.Diffuse.g=mtrl.Ambient.g=1.0f;
			mtrl.Diffuse.b=mtrl.Ambient.b=1.0f;
			mtrl.Diffuse.a=mtrl.Ambient.a=1.0f;
			g_pd3dDevice->SetMaterial( &mtrl );
		}
		obj->DrawSubset(0);
	}
}

void destroysceneobj_subset(struct sceneobject_s *sobj)
{
	LPD3DXMESH obj=(LPD3DXMESH) sobj->data;
	free(sobj->name);
	sobj->name=NULL;
	sobj->render=NULL;
	sobj->destroy=NULL;
	SAFE_RELEASE( obj );
	sobj->data=NULL;
}

sceneobject_t *findsceneobj(const char* name)
{
	int i;
	for(i=0; i<128; i++) {
		if(sceneobjectlist[i].name != NULL) {
			if(!strcmp(name, sceneobjectlist[i].name))
				return &(sceneobjectlist[i]);
		}
	}
	return NULL;
}

scenetxr_t *findscenetxr(const char* name)
{
	int i;
	for(i=0; i<128; i++) {
		if(scenetxrlist[i].name != NULL && scenetxrlist[i].data != NULL) {
			if(!strcmp(name, scenetxrlist[i].name))
				return &(scenetxrlist[i]);
		}
	}
	return NULL;
}

int lua_loadmesh(lua_State *L)
{
	int n=lua_gettop(L);
    int i;

	char *name=NULL, *filename=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
			case 2:	filename=strdup(lua_tostring(L, i)); break;
		}
    }

	if(name!=NULL && filename!=NULL) {
		for(i=0; i<128; i++) {
			if(sceneobjectlist[i].name==NULL) break;
		}
		if(i!=128) {
			localmesh_t *obj=(localmesh_t *)malloc(sizeof(localmesh_t));
			LoadXBGFile( filename, obj );
			sceneobjectlist[i].name=name;
			sceneobjectlist[i].render=rendersceneobj_frame;
			sceneobjectlist[i].destroy=destroysceneobj_frame;
			sceneobjectlist[i].data=(void*)obj;
		}
	}

	return 0;
}

int lua_loadtexture(lua_State *L)
{
	int n=lua_gettop(L);
    int i;

	char *name=NULL, *filename=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=(char*)lua_tostring(L, i); break;
			case 2:	filename=(char*)lua_tostring(L, i); break;
		}
    }

	if(name!=NULL && filename!=NULL && name[0] && filename[0]) {
		for(i=0; i<128; i++) {
			if(scenetxrlist[i].name==NULL) {
				DbgPrintf("Texture Slot %i = %s\n", i, filename);
				scenetxrlist[i].name=strdup(name);
				if(matchext(filename,"xpr") || matchext(filename,"xbx")) {
					scenetxrlist[i].data=(LPDIRECT3DTEXTURE8)LoadTextureFromXPR( filename );
					scenetxrlist[i].type=1;
				} else if(matchext(filename,"bmp")) {
					if(D3DXCreateTextureFromFileA(g_pd3dDevice, filename, &(scenetxrlist[i].data))!=S_OK)
						DbgPrintf("Unable to open texture %s\n", filename);
					scenetxrlist[i].type=0;
				}
				return 0;
			}
		}
	}

	return 0;
}

int lua_unloadtexture(lua_State *L)
{
	int n=lua_gettop(L);
    int i;

	char *name=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=(char*)lua_tostring(L, i); break;
		}
    }

	if(name!=NULL && name[0]) {
		for(i=0; i<128; i++) {
			if(!strcmp(scenetxrlist[i].name,name)) {
				free(scenetxrlist[i].name);
				scenetxrlist[i].name = NULL;
				if(scenetxrlist[i].type==0)	scenetxrlist[i].data->Release();
				if(scenetxrlist[i].type==1) {
					free(scenetxrlist[i].data);
				}
				scenetxrlist[i].data = NULL;
			}
		}
	}

	return 0;
}

int lua_reloadtexture(lua_State *L)
{
	int n=lua_gettop(L);
    int i;

	char *name=NULL, *filename=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=(char*)lua_tostring(L, i); break;
			case 2:	filename=(char*)lua_tostring(L, i); break;

		}
    }

	if(name!=NULL && filename!=NULL && name[0] && filename[0]) {
		for(i=0; i<128; i++) {
			if(!strcmp(scenetxrlist[i].name,name)) {
				free(scenetxrlist[i].name);
				scenetxrlist[i].name = NULL;
				if(scenetxrlist[i].type==0)	scenetxrlist[i].data->Release();
				if(scenetxrlist[i].type==1) {
					free(scenetxrlist[i].data);
				}
				scenetxrlist[i].data = NULL;
			}
		}
		for(i=0; i<128; i++) {
			if(scenetxrlist[i].name==NULL) {
				DbgPrintf("Texture Slot %i = %s\n", i, filename);
				scenetxrlist[i].name=strdup(name);
				if(matchext(filename,"xpr") || matchext(filename,"xbx")) {
					scenetxrlist[i].data=(LPDIRECT3DTEXTURE8)LoadTextureFromXPR( filename );
				} else if(matchext(filename,"bmp")) {
					if(D3DXCreateTextureFromFileA(g_pd3dDevice, filename, &(scenetxrlist[i].data))!=S_OK)
						DbgPrintf("Unable to open texture %s\n", filename);
				}
				return 0;
			}
		}
	}

	return 0;
}


int lua_lightenable(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	DWORD a=0,b=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	a=(DWORD)lua_tonumber(L, i); break;
			case 2:	b=(DWORD)lua_tonumber(L, i); break;
		}
    }

	g_pd3dDevice->LightEnable(a,b);

	return 0;
}

int lua_setrenderstate(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	DWORD a=0,b=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	a=(DWORD)lua_tonumber(L, i); break;
			case 2:	b=(DWORD)lua_tonumber(L, i); break;
		}
    }

	g_pd3dDevice->SetRenderStateNotInline((D3DRENDERSTATETYPE)a,b);

	return 0;
}

int lua_setrenderstatef(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	DWORD a=0;
	float b=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	a=(DWORD)lua_tonumber(L, i); break;
			case 2:	b=(float)lua_tonumber(L, i); break;
		}
    }

	g_pd3dDevice->SetRenderStateNotInline((D3DRENDERSTATETYPE)a, *((DWORD*) (&b)));

	return 0;
}

int lua_setrenderstateargb(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	DWORD x=0;
	unsigned char a=0,r=0,g=0,b=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	x=(DWORD)lua_tonumber(L, i); break;
			case 2:	a=(unsigned char)lua_tonumber(L, i); break;
			case 3:	r=(unsigned char)lua_tonumber(L, i); break;
			case 4:	g=(unsigned char)lua_tonumber(L, i); break;
			case 5:	b=(unsigned char)lua_tonumber(L, i); break;
		}
    }

	g_pd3dDevice->SetRenderStateNotInline((D3DRENDERSTATETYPE)x, (a<<24) | (r<<16) | (g<<8) | (b));

	return 0;
}

int lua_settexturestagestate(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	DWORD a=0,b=0,c=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	a=(DWORD)lua_tonumber(L, i); break;
			case 2:	b=(DWORD)lua_tonumber(L, i); break;
			case 3:	c=(DWORD)lua_tonumber(L, i); break;
		}
    }

	g_pd3dDevice->SetTextureStageStateNotInline(a,(D3DTEXTURESTAGESTATETYPE)b,c);

	return 0;
}

int lua_settexture(lua_State *L)
{
	int n=lua_gettop(L);
    int i,x=0;
	scenetxr_t *txr;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	txr=findscenetxr(lua_tostring(L, i)); break;
			case 2:	x=(int)lua_tonumber(L, i); break;
		}
    }

	if(txr!=NULL) {
		g_pd3dDevice->SetTexture(x, txr->data);
	}

	return 0;
}

int lua_stockmesh(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	float width=0, height=0, depth=0, blah=0;

	char *name=NULL, *type=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
			case 2:	type=(char*)lua_tostring(L, i); break;
			case 3:	width=(float)lua_tonumber(L, i); break;
			case 4:	height=(float)lua_tonumber(L, i); break;
			case 5:	depth=(float)lua_tonumber(L, i); break;
			case 6:	blah=(float)lua_tonumber(L, i); break;
		}
    }

	if(name!=NULL && type!=NULL) {
		for(i=0; i<128; i++) {
			if(sceneobjectlist[i].name==NULL) break;
		}
		if(i!=128) {
			if(!strcmp(type,"sphere")) {
				sceneobjectlist[i].name=name;
				sceneobjectlist[i].render=rendersceneobj_subset;
				sceneobjectlist[i].destroy=destroysceneobj_subset;
				if(height==0) height=16;
				if(depth==0) depth=16;
				D3DXCreateSphere( g_pd3dDevice, width, (UINT)height, (UINT)depth, (LPD3DXMESH*)&sceneobjectlist[i].data, NULL );
			} else if(!strcmp(type,"box")) {
				sceneobjectlist[i].name=name;
				sceneobjectlist[i].render=rendersceneobj_subset;
				sceneobjectlist[i].destroy=destroysceneobj_subset;
				D3DXCreateBox( g_pd3dDevice, width, height, depth, (LPD3DXMESH*)&sceneobjectlist[i].data, NULL );
			} else if(!strcmp(type,"cylinder")) {
				sceneobjectlist[i].name=name;
				sceneobjectlist[i].render=rendersceneobj_subset;
				sceneobjectlist[i].destroy=destroysceneobj_subset;
				D3DXCreateCylinder( g_pd3dDevice, width, width, height, (UINT)depth, 1, (LPD3DXMESH*)&sceneobjectlist[i].data, NULL );
			} else if(!strcmp(type,"cone")) {
				sceneobjectlist[i].name=name;
				sceneobjectlist[i].render=rendersceneobj_subset;
				sceneobjectlist[i].destroy=destroysceneobj_subset;
				D3DXCreateCylinder( g_pd3dDevice, width, height, depth, (UINT)blah, 1, (LPD3DXMESH*)&sceneobjectlist[i].data, NULL );
			} else if(!strcmp(type,"polygon")) {
				sceneobjectlist[i].name=name;
				sceneobjectlist[i].render=rendersceneobj_subset;
				sceneobjectlist[i].destroy=destroysceneobj_subset;
				D3DXCreatePolygon( g_pd3dDevice, width, (UINT)height, (LPD3DXMESH*)&sceneobjectlist[i].data, NULL );
			} else if(!strcmp(type,"torus")) {
				sceneobjectlist[i].name=name;
				sceneobjectlist[i].render=rendersceneobj_subset;
				sceneobjectlist[i].destroy=destroysceneobj_subset;
				if(depth<3) depth=3;
				D3DXCreateTorus( g_pd3dDevice, width, height, (UINT)depth, (UINT)depth, (LPD3DXMESH*)&sceneobjectlist[i].data, NULL );
			} else if(!strcmp(type,"teapot")) {
				sceneobjectlist[i].name=name;
				sceneobjectlist[i].render=rendersceneobj_subset;
				sceneobjectlist[i].destroy=destroysceneobj_subset;
				D3DXCreateTeapot( g_pd3dDevice, (LPD3DXMESH*)&sceneobjectlist[i].data, NULL );
			}
		}
	}

	return 0;
}

//SoundTracks
//Swolsten
//////////////////////////////////////
//									//
// Music Maker LUA file functions	//
//									//
//////////////////////////////////////
int lua_StopStartAudio (lua_State *L)
{
	if( m_pMusicManager->GetStatus() == MM_PLAYING )
		m_pMusicManager->Stop();
	else
		m_pMusicManager->Play();
	return 1;
}

int lua_MusicPlaying (lua_State *L)
{
	int MusicPlaying = 0;
	if( m_pMusicManager->GetStatus() == MM_PLAYING )
		MusicPlaying = 1;
	lua_pushnumber (LUA_STATE,MusicPlaying);
	lua_setglobal (LUA_STATE,"Playing");
	return 1;
}

int lua_NextSong (lua_State *L)
{
	m_pMusicManager->NextSong();
	return 1;
}

int lua_NextTrack (lua_State *L)
{
	m_pMusicManager->NextSoundtrack();
	return 1;
}

int lua_PauseAudio (lua_State *L)
{
	{
	    BOOL bWasPlaying = ( m_pMusicManager->GetStatus() == MM_PLAYING ) ? TRUE : FALSE;
        BOOL bWasPaused  = ( m_pMusicManager->GetStatus() == MM_PAUSED ) ? TRUE : FALSE;

        if( bWasPlaying || bWasPaused )
            m_pMusicManager->Stop();

        m_pMusicManager->RandomSong( m_pMusicManager->GetGlobal() );

		if( bWasPlaying || bWasPaused ){
            m_pMusicManager->Play();
		}
		if( bWasPaused ) {
            m_pMusicManager->Pause();
		}
	}
	return 1;
}

int lua_GetSongInfo (lua_State *L)
{
	WCHAR strSongName[MAX_SONG_NAME];
	WCHAR strSoundtrackName[MAX_SOUNDTRACK_NAME];
	DWORD pdwLength;
	m_pMusicManager->GetCurrentInfo(strSoundtrackName, strSongName, &pdwLength );
	lua_pushstring (LUA_STATE,lstrdupAfromW(strSongName));
	lua_setglobal (LUA_STATE,"Song");
	lua_pushstring (LUA_STATE,lstrdupAfromW(strSoundtrackName));

	lua_setglobal (LUA_STATE,"SoundTrack");
	return 1;
}
//End SoundTracks

int lua_loadsound(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	const char *name=NULL, *fn=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
			case 2:	fn=lua_tostring(L, i); break;
		}
    }

	if(name!=NULL && fn!=NULL) {
		for(i=0; i<32; i++) {
			if(scenesoundlist[i].name==NULL) {
				if(scenesoundlist[i].data.Create(fn)==S_OK) {
					scenesoundlist[i].name=strdup(name);
					return 0;
				}
			}
		}
	}
	
	return 0;
}

int lua_unloadsound(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	const char *name=NULL, *fn=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
			case 2:	fn=lua_tostring(L, i); break;
		}
    }

	if(name!=NULL) {
		for(i=0; i<32; i++) {
			if(scenesoundlist[i].name!=NULL && !strcmp(scenesoundlist[i].name,name)) {
				scenesoundlist[i].data.Destroy();
				free(scenesoundlist[i].name);
				scenesoundlist[i].name=NULL;
				return 0;
			}
		}
	}
	
	return 0;
}

int lua_playsound(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	const char *name=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
		}
    }

	if(name!=NULL) {
		for(i=0; i<32; i++) {
			if(scenesoundlist[i].name!=NULL && !strcmp(scenesoundlist[i].name,name)) {
				scenesoundlist[i].data.Play();
				return 0;
			}
		}
	}

	return 0;
}

int lua_setvolume(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	const char *name=NULL;
	long vol;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
			case 2: vol=(long)lua_tonumber(L, i); break;
		}
    }

#if 0
	if(name!=NULL) {
		for(i=0; i<32; i++) {
			if(scenesoundlist[i].name!=NULL && !strcmp(scenesoundlist[i].name,name)) {
				scenesoundlist[i].data.SetVolume(vol);
				return 0;
			}
		}
	}
#endif

	return 0;
}

DWORD TextColor=0xffffffff;
UINT FontNumber=0;

int lua_loadfont(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	const char *name=NULL, *fn=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
			case 2:	fn=lua_tostring(L, i); break;
		}
    }

	if(name!=NULL && fn!=NULL) {
		for(i=0; i<32; i++) {
			if(scenefontlist[i].name==NULL) {
				if(scenefontlist[i].data.Create(fn)==S_OK) {
					scenefontlist[i].name=strdup(name);
					return 0;
				}
			}
		}
	}
	
	return 0;
}

int lua_unloadfont(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	const char *name=NULL, *fn=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
			case 2:	fn=lua_tostring(L, i); break;
		}
    }

	if(name!=NULL) {
		for(i=0; i<32; i++) {
			if(scenefontlist[i].name!=NULL && !strcmp(scenefontlist[i].name,name)) {
				if(scenefontlist[i].data.Destroy() == S_OK) {
					free(scenefontlist[i].name);
					scenefontlist[i].name=NULL;
					return 0;
				}
			}
		}
	}
	
	return 0;
}

int lua_setfont(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	const char *name=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	name=strdup(lua_tostring(L, i)); break;
		}
    }

	if(name!=NULL) {
		for(i=0; i<32; i++) {
			if(scenefontlist[i].name!=NULL && !strcmp(scenefontlist[i].name,name)) {
				FontNumber=i;
				return 0;
			}
		}
	}

	return 0;
}

int lua_settextargb(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	unsigned char a=0,r=0,g=0,b=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	a=(unsigned char)lua_tonumber(L, i); break;
			case 2:	r=(unsigned char)lua_tonumber(L, i); break;
			case 3:	g=(unsigned char)lua_tonumber(L, i); break;
			case 4:	b=(unsigned char)lua_tonumber(L, i); break;
		}
    }

	TextColor=((a<<24) | (r<<16) | (g<<8) | (b));

	return 0;
}

int lua_rendertext(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	float x=0, y=0, sx=1, sy=0;
	char *text;
	WCHAR *wtext;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	text=(char *)lua_tostring(L, i); break;
			case 2:	x=(float)lua_tonumber(L, i); break;
			case 3:	y=(float)lua_tonumber(L, i); break;
			case 4:	sx=(float)lua_tonumber(L, i); break;
			case 5:	sy=(float)lua_tonumber(L, i); break;
		}
    }

	if(text==NULL) return 0;

	wtext=lstrdupWfromA(text);

	if(scenefontlist[FontNumber].name!=NULL) {
		scenefontlist[FontNumber].data.Begin();
		if(sy!=0) {
			scenefontlist[FontNumber].data.DrawScaledText(  x+1, y+1, sx, sy, 0xff000000&TextColor, wtext );
			scenefontlist[FontNumber].data.DrawScaledText(  x, y, sx, sy, 0xffffffff&TextColor, wtext );
		} else if(sx!=1) {
			scenefontlist[FontNumber].data.DrawScaledText(  x+1, y+1, sx, sx, 0xff000000&TextColor, wtext );
			scenefontlist[FontNumber].data.DrawScaledText(  x, y, sx, sx, 0xffffffff&TextColor, wtext );
		} else {
			scenefontlist[FontNumber].data.DrawText(  x+1, y+1, 0xff000000&TextColor, wtext );
			scenefontlist[FontNumber].data.DrawText(  x, y, 0xffffffff&TextColor, wtext );
		}
		scenefontlist[FontNumber].data.End();
	}

	free(wtext);

	return 0;
}

int lua_rendernum(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	float x=0, y=0;
	float num=0;
	WCHAR *wtext;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	num=(float)lua_tonumber(L, i); break;
			case 2:	x=(float)lua_tonumber(L, i); break;
			case 3:	y=(float)lua_tonumber(L, i); break;
		}
    }

	wtext=(WCHAR*)malloc(128);

	wsprintfW(wtext, L"%0.2f", num);

	if(scenefontlist[FontNumber].name != NULL) {
		scenefontlist[FontNumber].data.Begin();
		scenefontlist[FontNumber].data.DrawText(  x+1, y+1, 0xff000000&TextColor, wtext );
		scenefontlist[FontNumber].data.DrawText(  x, y, 0xffffffff&TextColor, wtext );
		scenefontlist[FontNumber].data.End();
	}

	free(wtext);

	return 0;
}

int lua_renderint(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	float x=0, y=0;
	int num=0;
	WCHAR *wtext;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	num=(int)lua_tonumber(L, i); break;
			case 2:	x=(float)lua_tonumber(L, i); break;
			case 3:	y=(float)lua_tonumber(L, i); break;
		}
    }

	wtext=(WCHAR*)malloc(128);

	wsprintfW(wtext, L"%d", num);

	if(scenefontlist[FontNumber].name!=NULL) {
		scenefontlist[FontNumber].data.Begin();
		scenefontlist[FontNumber].data.DrawText(  x+1, y+1, 0xff000000&TextColor, wtext );
		scenefontlist[FontNumber].data.DrawText(  x, y, 0xffffffff&TextColor, wtext );
		scenefontlist[FontNumber].data.End();
	}

	free(wtext);

	return 0;
}

int lua_renderobject(lua_State *L)
{
	int n=lua_gettop(L);
    int i, m=0;
	float x=0, y=0, z=0, u=0, v=0, w=0, sx=1, sy=1, sz=1;
	sceneobject_t *object;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:		object=findsceneobj(lua_tostring(L, i)); break;
			case 2:		m=(int)lua_tonumber(L, i); break;
			case 3:		x=(float)lua_tonumber(L, i); break;
			case 4:		y=(float)lua_tonumber(L, i); break;
			case 5:		z=(float)lua_tonumber(L, i); break;
			case 6:		u=(float)lua_tonumber(L, i); break;
			case 7:		v=(float)lua_tonumber(L, i); break;
			case 8:		w=(float)lua_tonumber(L, i); break;
			case 9:		sx=(float)lua_tonumber(L, i); break;
			case 10:	sy=(float)lua_tonumber(L, i); break;
			case 11:	sz=(float)lua_tonumber(L, i); break;
		}
    }

	if(object!=NULL && object->data !=NULL) {
		MakeWorldMatrix( &matObject, x, y, z, u, v, w);
		D3DXMatrixMultiply( &matWorld, &matObject, &matOriginalWorld );
		if(sx!=1 || sy!=1 || sz!=1) {
			D3DXMatrixScaling( &matObject, sx, sy, sz);
			D3DXMatrixMultiply( &matWorld, &matObject, &matWorld );
		}
		g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );
		object->render(object, m);
	}
	return 0;
}

int lua_setupxray(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	unsigned char m=0, a=0, r=0, g=0, b=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: m=(unsigned char)lua_tonumber(L, i); break;
			case 2: a=(unsigned char)lua_tonumber(L, i); break;
			case 3: r=(unsigned char)lua_tonumber(L, i); break;
			case 4: g=(unsigned char)lua_tonumber(L, i); break;
			case 5: b=(unsigned char)lua_tonumber(L, i); break;
		}
    }

	if(m) {
		g_pd3dDevice->SetRenderState( D3DRS_ZENABLE,			TRUE );
		g_pd3dDevice->SetRenderState( D3DRS_ZWRITEENABLE,		FALSE );
		g_pd3dDevice->SetRenderState( D3DRS_LIGHTING,			FALSE );
		g_pd3dDevice->SetRenderState( D3DRS_CULLMODE,			D3DCULL_NONE );
		g_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,	TRUE );
		g_pd3dDevice->SetRenderState( D3DRS_SRCBLEND,			D3DBLEND_CONSTANTALPHA );
		g_pd3dDevice->SetRenderState( D3DRS_DESTBLEND,			D3DBLEND_ONE );
		g_pd3dDevice->SetRenderState( D3DRS_TEXTUREFACTOR,		(0xff<<24) | (r<<16) | (g<<8) | (b) );
		g_pd3dDevice->SetRenderState( D3DRS_BLENDCOLOR,			(a<<24) );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_TFACTOR );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
	    g_pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );

		D3DXMATRIX mat;
		mat._11 = 0.5f; mat._12 = 0.0f;
		mat._21 = 0.0f; mat._22 =-0.5f;
		mat._31 = 0.0f; mat._32 = 0.0f;
		mat._41 = 0.5f; mat._42 = 0.5f;
		g_pd3dDevice->SetTransform( D3DTS_TEXTURE0, &mat );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_CAMERASPACENORMAL );
	} else {
		g_pd3dDevice->SetRenderState( D3DRS_ZENABLE,			TRUE );
		g_pd3dDevice->SetRenderState( D3DRS_ZWRITEENABLE,		TRUE );
		g_pd3dDevice->SetRenderState( D3DRS_LIGHTING,			TRUE );
		g_pd3dDevice->SetRenderState( D3DRS_CULLMODE,			D3DCULL_CCW );
		g_pd3dDevice->SetRenderState( D3DRS_SPECULARENABLE,		FALSE );
		g_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,	TRUE );
		g_pd3dDevice->SetRenderState( D3DRS_BLENDOP,			D3DBLENDOP_ADD );
		g_pd3dDevice->SetRenderState( D3DRS_SRCBLEND,			D3DBLEND_CONSTANTCOLOR );
		g_pd3dDevice->SetRenderState( D3DRS_DESTBLEND,			D3DBLEND_DESTCOLOR );
		g_pd3dDevice->SetRenderState( D3DRS_BLENDCOLOR,			(a<<24) | (r<<16) | (g<<8) | (b) );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
		g_pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
	}

	return 0;
}

int lua_geteepromfromxbox(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	unsigned char m=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: m=(unsigned char)lua_tonumber(L, i); break;
		}
    }
	if(EEPROMData==NULL) {
		EEPROMData=(LPEEPROMDATA)malloc(sizeof(EEPROMDATA));
		m=1;
	}
	if(m==1) {
		m_xkeeprom.ReadFromXBOX();
		xver=m_xkeeprom.GetXBOXVersion();
		EEPROMData_Enc=m_xkeeprom.IsEncrypted();
		m_xkeeprom.GetEEPROMData(EEPROMData);
	}

	return 0;
}

int lua_writeeepromtoxbox(lua_State *L) {
	if(EEPROMData==NULL) return 0;

	if(!EEPROMData_Enc) {
		m_xkeeprom.SetDecryptedEEPROMData(xver, EEPROMData);
		m_xkeeprom.EncryptAndCalculateCRC(xver);
	} else {
		m_xkeeprom.SetEncryptedEEPROMData(EEPROMData);
	}
	m_xkeeprom.CalculateChecksum2();
	m_xkeeprom.CalculateChecksum3();
	m_xkeeprom.WriteToXBOX();

	return 0;
}

int lua_setwidescreen(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	unsigned char m=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: m=(unsigned char)lua_tonumber(L, i); break;
		}
    }

	if(m>2) m=0;
	if(m==0x02) m=0x10;
	if(EEPROMData==NULL) return 0;
	EEPROMData->VideoFlags[2] &= 0xee;
	EEPROMData->VideoFlags[2] |= m;

	return 0;
}

int lua_getwidescreen(lua_State *L)
{
	if(EEPROMData==NULL) return 0;
	unsigned char m=EEPROMData->VideoFlags[2] & 0x11;

	if(m>1) m=2;

	lua_pushnumber(L, m);

	return 1;
}

int lua_sethdtv(lua_State *L)
{
	if(EEPROMData==NULL) return 0;

	int n=lua_gettop(L);
    int i;
	unsigned char m=0, a=0, b=0, c=0;

	m =	EEPROMData->VideoFlags[2];

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: 
				if((unsigned char)lua_tonumber(L, i)) m |= 0x02;
				else m &= 0xfd;
				break;
			case 2: 
				if((unsigned char)lua_tonumber(L, i)) m |= 0x04;
				else m &= 0xfb;
				break;
			case 3: 
				if((unsigned char)lua_tonumber(L, i)) m |= 0x08;
				else m &= 0xf7;
				break;
		}
    }

	EEPROMData->VideoFlags[2] = m;

	return 0;
}

int lua_gethdtv(lua_State *L)
{
	if(EEPROMData==NULL) return 0;
	unsigned char m=EEPROMData->VideoFlags[2] & 0xe;

	lua_pushnumber(L, (m&0x02) ? 1 : 0);
	lua_pushnumber(L, (m&0x04) ? 1 : 0);
	lua_pushnumber(L, (m&0x08) ? 1 : 0);

	return 3;
}

int lua_getaudio(lua_State *L)
{
	if(EEPROMData==NULL) return 0;
	unsigned char m=EEPROMData->AudioFlags[0] & 0x11;

	if(m>1) m=2;

	lua_pushnumber(L, m);

	return 1;
}

int lua_setaudio(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	unsigned char m=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: m=(unsigned char)lua_tonumber(L, i); break;
		}
    }

	if(m>2) m=0;
	if(m==0x02) m=0x10;
	if(EEPROMData==NULL) return 0;
	EEPROMData->AudioFlags[0] &= 0xee;
	EEPROMData->AudioFlags[0] |= m;

	return 0;
}

int lua_setspdif(lua_State *L)
{
	if(EEPROMData==NULL) return 0;

	int n=lua_gettop(L);
    int i;
	unsigned char m=0, a=0, b=0, c=0;

	m =	EEPROMData->AudioFlags[2];

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: 
				if((unsigned char)lua_tonumber(L, i)) m |= 0x01;
				else m &= 0xfe;
				break;
			case 2: 
				if((unsigned char)lua_tonumber(L, i)) m |= 0x02;
				else m &= 0xfd;
				break;
		}
    }

	EEPROMData->AudioFlags[2] = m;

	return 0;
}

int lua_getspdif(lua_State *L)
{
	if(EEPROMData==NULL) return 0;
	unsigned char m=EEPROMData->AudioFlags[2];

	lua_pushnumber(L, (m&0x01) ? 1 : 0);
	lua_pushnumber(L, (m&0x02) ? 1 : 0);

	return 2;
}

int lua_getclock(lua_State *L)
{
	SYSTEMTIME localtime;
	WORD i;
	int pm=0;

	GetLocalTime(&localtime);

	i=localtime.wHour;
	if(i>11) pm=1;
	if(i==0) i=12;
	if(i>12) i-=12;

	lua_pushnumber(L, i);
	lua_pushnumber(L, localtime.wMinute);
	lua_pushstring(L, (pm) ? "PM" : "AM");
	lua_pushnumber(L, localtime.wDay);
	lua_pushnumber(L, localtime.wMonth);
	lua_pushnumber(L, localtime.wYear%100);

	return 6;
}

int lua_findfiles(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;
	const char *where=NULL;
	const char *filter=NULL;
	int norecursion=0;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
			case 2: where = lua_tostring(L, i); break;
			case 3: filter = lua_tostring(L, i); break;
			case 4: norecursion = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0 && where) {
		Menu[mnu].AddFiles(where, filter, norecursion);
		Menu[mnu].IndexList();
		lua_pushnumber(L, Menu[mnu].NodeCount());
		
		return 1;
	}

	lua_pushnumber(L, 0);
	return 1;
}

int lua_getmenu(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0) {
		lua_pushnumber(L, Menu[mnu].NodeCount());
		return 1;
	}

	lua_pushnumber(L, 0);
	return 1;

}

int lua_getmenuname(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0) {
		lua_pushstring(L, Menu[mnu].GetName());
		return 1;
	}

	lua_pushstring(L, "-- NULL --");
	return 1;
}

int lua_getitemstring(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;
	int itm=-1;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
			case 2: itm = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0 && itm>=0) {
		if (Menu[mnu].IndexedMenu[itm]->Title!=NULL) {
			lua_pushstring(L, Menu[mnu].IndexedMenu[itm]->Title);
			return 1;
		} else {
			char * name = NULL;
			sprintf (name,"IndexedMenu[%d] = NULL",itm);
			lua_pushstring(L, name);
			return 1;
		}
	}

	lua_pushstring(L, "-- NULL --");
	return 1;
}

int lua_getitemtype(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;
	int itm=-1;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
			case 2: itm = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0 && itm>=0) {
		lua_pushnumber(L, Menu[mnu].IndexedMenu[itm]->Action);
		return 1;
	}

	lua_pushnumber(L, -1);
	return 1;
}

int lua_getitemfilename(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;
	int itm=-1;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
			case 2: itm = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0 && itm>=0) {
		lua_pushstring(L, Menu[mnu].IndexedMenu[itm]->File);
		return 1;
	}

	lua_pushstring(L, "-- NULL --");
	return 1;
}

int lua_getitemiconpath(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;
	int itm=-1;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
			case 2: itm = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0 && itm>=0) {
		lua_pushstring(L, Menu[mnu].IndexedMenu[itm]->Icon);
		return 1;
	}

	lua_pushstring(L, "-- NULL --");
	return 1;
}

int lua_getitemdblocks(lua_State *L) {
	int n=lua_gettop(L);
    int i;
	int mnu=-1;
	int itm=-1;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: mnu = (int)lua_tonumber(L, i); break;
			case 2: itm = (int)lua_tonumber(L, i); break;
		}
    }

	if(mnu>=0 && itm>=0) {
		lua_pushnumber(L, Menu[mnu].IndexedMenu[itm]->DBlocks);
		return 1;
	}

	lua_pushnumber(L, 0);
	return 1;
}

// Overkill, if any idiot actually uses shit that overflows this then they deserve what they get.
char ftpclient_user[30];
char ftpclient_pass[30];

DWORD WINAPI T_DoOpen(LPVOID string) {
	progressmax=3;
	theFtpConnection->DoOpen((char *) string);

	char user_pass[64];
	sprintf(user_pass, "%s:%s", ftpclient_user, ftpclient_pass);
	//sprintf(user_pass, "%s:", "xbox", "");
	theFtpConnection->DoLogin(user_pass);
	// progress++ causes Black screen on Connect
	//progressbar++;
	theFtpConnection->DoList("dirFiltered");
	//theFtpConnection->DoList("dir");
	//progressbar++;
	theFtpConnection->DoLLS("*");

	return 0;
}

int lua_ftpopen(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *remote;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: remote = (char *)lua_tostring(L, i); break;
		}
    }

	if(remote!=NULL) {
		if(CreateThread(NULL, 0, T_DoOpen, remote, 0, NULL)!=NULL) {
			lua_pushnumber(L, 1);
			return 1;
		}
	}

	lua_pushnumber(L, 0);
	return 1;
}

DWORD WINAPI T_DoList(LPVOID string) {
	theFtpConnection->DoList("dirFiltered");
	return 0;
}

int lua_ftplist(lua_State *L)
{
	if(CreateThread(NULL, 0, T_DoList, NULL, 0, NULL)!=NULL) {
		lua_pushnumber(L, 1);
		return 1;
	}

	lua_pushnumber(L, 0);
	return 1;
}

DWORD WINAPI T_DoLLS(LPVOID string) {
	theFtpConnection->DoLLS("*");
	return 0;
}

int lua_ftplls(lua_State *L)
{
	if(CreateThread(NULL, 0, T_DoLLS, NULL, 0, NULL)!=NULL) {
		lua_pushnumber(L, 1);
		return 1;
	}

	lua_pushnumber(L, 0);
	return 1;
}

DWORD WINAPI T_DoCD(LPVOID string) {
	theFtpConnection->DoCD((char *) string);
	theFtpConnection->DoList("dirFiltered");
	return 0;
}

int lua_ftpcd(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *type;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: type = (char *)lua_tostring(L, i); break;
		}
    }

	if(type!=NULL) {
		if(CreateThread(NULL, 0, T_DoCD, type, 0, NULL)!=NULL) {
			lua_pushnumber(L, 1);
			return 1;
		}
	}

	lua_pushnumber(L, 0);
	return 1;
}

int lua_ftpsetuser(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *type;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: type = (char *)lua_tostring(L, i); break;
		}
    }

	if(type!=NULL) {
		strcpy(ftpclient_user, type);
	}

	return 0;
}

int lua_ftpsetpass(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *type;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: type = (char *)lua_tostring(L, i); break;
		}
    }

	if(type!=NULL) {
		strcpy(ftpclient_pass, type);
	}

	return 0;
}

int lua_ftpclose(lua_State *L)
{
	theFtpConnection->DoClose();
	return 0;
}

DWORD WINAPI T_DoLCD(LPVOID string) {
	theFtpConnection->DoLCD((char *) string);
	theFtpConnection->DoLLS("*");
	return 0;
}

int lua_ftplcd(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *type;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: type = (char *)lua_tostring(L, i); break;
		}
    }

	if(type!=NULL) {
		if(CreateThread(NULL, 0, T_DoLCD, type, 0, NULL)!=NULL) {
			lua_pushnumber(L, 1);
			return 1;
		}
	}

	lua_pushnumber(L, 0);
	return 1;
}

DWORD WINAPI T_DoPut(LPVOID string) {
	theFtpConnection->DoPut((char *) string);
	return 0;
}

int lua_ftpput(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *type;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: type = (char *)lua_tostring(L, i); break;
		}
    }

	if(type!=NULL) {
		if(CreateThread(NULL, 0, T_DoPut, type, 0, NULL)!=NULL) {
			lua_pushnumber(L, 1);
			return 1;
		}
	}

	lua_pushnumber(L, 0);
	return 1;
}

DWORD WINAPI T_DoGet(LPVOID string) {
	theFtpConnection->DoGet((char *) string);
	return 0;
}

int lua_ftpget(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *type;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: type = (char *)lua_tostring(L, i); break;
		}
    }

	if(type!=NULL) {
		if(CreateThread(NULL, 0, T_DoGet, type, 0, NULL)!=NULL) {
			lua_pushnumber(L, 1);
			return 1;
		}
	}

	lua_pushnumber(L, 0);
	return 1;
}

int lua_ftpbinary(lua_State *L)
{
	theFtpConnection->DoBinary();
	return 0;
}

int lua_ftpascii(lua_State *L)
{
	theFtpConnection->DoAscii();
	return 0;
}

int lua_ftppwd(lua_State *L)
{
	theFtpConnection->DoPWD();
	return 0;
}

int lua_launchxbe(lua_State *L)
{
	int n=lua_gettop(L);
    int i;
	char *xbefile=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1: xbefile = (char*)lua_tostring(L, i); break;
		}
    }

	if(xbefile!=NULL)
		LaunchMyXBE(xbefile,NULL);

	return 0;
}

extern "C" {
	int lua_customprint(lua_State *L);
}

#include <setjmp.h>
jmp_buf jmpbuffer;
int lua_finished(lua_State *L)
{
	longjmp( jmpbuffer, -1 );
}

char *scenelua;
size_t sceneluas;

char *LASTSCENE;
char *LOADNEWSCENE;
char *LUACMDLINE;
int lua_setupnewscene(lua_State *L)
{
	int n=lua_gettop(L);
    int i;

	if(LOADNEWSCENE!=NULL) free(LOADNEWSCENE);
	if(LUACMDLINE!=NULL) free(LUACMDLINE);
	LOADNEWSCENE=NULL;
	LUACMDLINE=NULL;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	LOADNEWSCENE=strdup(lua_tostring(L, i)); break;
			case 2:	LUACMDLINE=strdup(lua_tostring(L, i)); break;
		}
	}
	return 0;
}

int lua_round(lua_State *L)
{
	int n=lua_gettop(L), i, ival, digits=0;
	double val=0, oval;

	for (i=1; i <= n; i++) {
		switch(i) {
			case 1:	val=(double)lua_tonumber(L, i); break;
			case 2:	digits=(int)lua_tonumber(L, i); break;
		}
	}

	ival=(int)(val*pow(10,digits));
	oval=((float)ival)/pow(10,digits);

	val-=oval;
	if(val>0.5) oval+=1;

	lua_pushnumber(L, oval);
	return 1;
}

HRESULT CXBoxSample::CheckFile(char *fn)
{
	HANDLE sceneluaf = CreateFileA( fn, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL );
	if(sceneluaf == INVALID_HANDLE_VALUE) {
		OutputDebugStringA("Could not load ");
		OutputDebugStringA(fn);
		OutputDebugStringA("\n");
		DWORD eno=GetLastError();
		return ERROR_FILE_NOT_FOUND;
	}
	CloseHandle( sceneluaf );
	return S_OK;
}

HRESULT CXBoxSample::LoadScene(char *fn)
{
	char* localfn=strdup(fn);
	HANDLE sceneluaf = CreateFileA( localfn, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, NULL );
	if(sceneluaf == INVALID_HANDLE_VALUE) {
		OutputDebugStringA("Could not load ");
		OutputDebugStringA(fn);
		OutputDebugStringA("\n");
		DWORD eno=GetLastError();
		return ERROR_FILE_NOT_FOUND;
	}

	LUA_STATE=lua_open(0);
	lua_mathlibopen(LUA_STATE);
	lua_register(LUA_STATE, "setupxray", lua_setupxray);
	lua_register(LUA_STATE, "lightenable", lua_lightenable);
	lua_register(LUA_STATE, "setrenderstateargb", lua_setrenderstateargb);
	lua_register(LUA_STATE, "setrenderstatef", lua_setrenderstatef);
	lua_register(LUA_STATE, "setrenderstate", lua_setrenderstate);
	lua_register(LUA_STATE, "settexturestagestate", lua_settexturestagestate);
	lua_register(LUA_STATE, "newscene", lua_setupnewscene);
	lua_register(LUA_STATE, "stockmesh", lua_stockmesh);
	lua_register(LUA_STATE, "loadmesh", lua_loadmesh);
	lua_register(LUA_STATE, "loadtexture", lua_loadtexture);
	lua_register(LUA_STATE, "reloadtexture", lua_reloadtexture);
	lua_register(LUA_STATE, "unloadtexture", lua_unloadtexture);
	lua_register(LUA_STATE, "settexture", lua_settexture);
	lua_register(LUA_STATE, "renderobject", lua_renderobject);
	lua_register(LUA_STATE, "settextargb", lua_settextargb);
	lua_register(LUA_STATE, "setfont", lua_setfont);
	lua_register(LUA_STATE, "loadfont", lua_loadfont);
	lua_register(LUA_STATE, "rendertext", lua_rendertext);
	lua_register(LUA_STATE, "rendernum", lua_rendernum);
	lua_register(LUA_STATE, "renderint", lua_renderint);
	lua_register(LUA_STATE, "_ERRORMESSAGE", lua_customprint);
	lua_register(LUA_STATE, "finished", lua_finished);
	lua_register(LUA_STATE, "round", lua_round);

	lua_register(LUA_STATE, "readeepromfromxbox", lua_geteepromfromxbox);
	lua_register(LUA_STATE, "writeeepromtoxbox", lua_writeeepromtoxbox);

	lua_register(LUA_STATE, "gethdtv", lua_gethdtv);
	lua_register(LUA_STATE, "sethdtv", lua_sethdtv);
	lua_register(LUA_STATE, "getwidescreen", lua_getwidescreen);
	lua_register(LUA_STATE, "setwidescreen", lua_setwidescreen);
	lua_register(LUA_STATE, "getaudio", lua_getaudio);
	lua_register(LUA_STATE, "setaudio", lua_setaudio);
	lua_register(LUA_STATE, "getspdif", lua_getspdif);
	lua_register(LUA_STATE, "setspdif", lua_setspdif);

	lua_register(LUA_STATE, "getclock", lua_getclock);

	lua_register(LUA_STATE, "findfiles", lua_findfiles);
	lua_register(LUA_STATE, "getmenu", lua_getmenu);
	lua_register(LUA_STATE, "getitemstring", lua_getitemstring);
	lua_register(LUA_STATE, "getitemfilename", lua_getitemfilename);
	lua_register(LUA_STATE, "getitemiconpath", lua_getitemiconpath);
	lua_register(LUA_STATE, "getitemdblocks", lua_getitemdblocks);
	lua_register(LUA_STATE, "getitemtype", lua_getitemtype);

	lua_register(LUA_STATE, "ftpopen", lua_ftpopen);
	lua_register(LUA_STATE, "ftpclose", lua_ftpclose);
	lua_register(LUA_STATE, "ftplist", lua_ftplist);
	lua_register(LUA_STATE, "ftpcd", lua_ftpcd);
	lua_register(LUA_STATE, "ftpsetuser", lua_ftpsetuser);
	lua_register(LUA_STATE, "ftpsetpass", lua_ftpsetpass);
	lua_register(LUA_STATE, "ftplcd", lua_ftplcd);
	lua_register(LUA_STATE, "ftpput", lua_ftpput);
	lua_register(LUA_STATE, "ftpget", lua_ftpget);
	lua_register(LUA_STATE, "ftplls", lua_ftplls);
	lua_register(LUA_STATE, "ftpbinary", lua_ftpbinary);
	lua_register(LUA_STATE, "ftpascii", lua_ftpascii);
	lua_register(LUA_STATE, "ftppwd", lua_ftppwd);

	//New Audio Bindings
	// Audio functions
	lua_register(LUA_STATE, "AudioPause",lua_PauseAudio);
	lua_register(LUA_STATE, "NextSoundtrack", lua_NextTrack);
	lua_register(LUA_STATE, "NextSong", lua_NextSong);
	lua_register(LUA_STATE, "MusicPlaying", lua_MusicPlaying);
	lua_register(LUA_STATE, "GetSongInfo", lua_GetSongInfo);
	lua_register(LUA_STATE, "StopStartAudio",lua_StopStartAudio);

	
	lua_register(LUA_STATE, "launchxbe", lua_launchxbe);

	if(LUACMDLINE!=NULL) {
		lua_pushstring(LUA_STATE, LUACMDLINE);
		lua_setglobal(LUA_STATE, "cmdline");
		free(LUACMDLINE);
		LUACMDLINE=NULL;
	}
	if(LOADNEWSCENE!=NULL) {
		free(LOADNEWSCENE);
		LOADNEWSCENE=NULL;
	}
	if(LASTSCENE!=NULL) {
		lua_pushstring(LUA_STATE, LASTSCENE);
		lua_setglobal(LUA_STATE, "lastscene");
		free(LASTSCENE);
		LASTSCENE=NULL;
	}
	LASTSCENE=localfn;

	xver=m_xkeeprom.GetXBOXVersion();

	m_xkeeprom.Decrypt();
	//Get XBOX Version...
	if (xver == XKEEPROM::XBOX_VERSION::V1_0)
		//OUTPUT_DEBUG_STRING("INFO: Detected XBOX Version: 1.0\n");
		lua_pushstring(LUA_STATE, "1.0");
	else if (xver == XKEEPROM::XBOX_VERSION::V1_1)
		//OUTPUT_DEBUG_STRING("INFO: Detected XBOX Version: 1.1\n");
		lua_pushstring(LUA_STATE, "1.1");
	else if (xver == XKEEPROM::XBOX_VERSION::V1_2)
		//OUTPUT_DEBUG_STRING("INFO: Detected XBOX Version: 1.2\n");
		lua_pushstring(LUA_STATE, "1.2");
	else if (xver == XKEEPROM::XBOX_VERSION::V1_3)
		//OUTPUT_DEBUG_STRING("INFO: Detected XBOX Version: 1.3\n");
		lua_pushstring(LUA_STATE, "1.3");
	else if (xver == XKEEPROM::XBOX_VERSION::V1_4)
		//OUTPUT_DEBUG_STRING("INFO: Detected XBOX Version: 1.4\n");
		lua_pushstring(LUA_STATE, "1.4");
	else if (xver == XKEEPROM::XBOX_VERSION::V1_5)
		//OUTPUT_DEBUG_STRING("INFO: Detected XBOX Version: 1.5\n");
		lua_pushstring(LUA_STATE, "1.5");
	else
		//OUTPUT_DEBUG_STRING("INFO: Detected XBOX Version: UNKOWN\n");
		lua_pushstring(LUA_STATE, "?.?");

	lua_setglobal(LUA_STATE, "xboxversion");

	lua_pushstring(LUA_STATE, "Version 1.0 RC0");
	lua_setglobal(LUA_STATE, "version");

//	char kernstr[32];
//	XDebugGetSystemVersion(kernstr, 31);
	//lua_pushstring(LUA_STATE, "unknown");
	//lua_setglobal(LUA_STATE, "kernversion");

	char kernstr[32];
	XDebugGetSystemVersion(kernstr, 31);
	lua_pushstring(LUA_STATE, kernstr);
	lua_setglobal(LUA_STATE, "kernversion");

	sceneluas=GetFileSize(sceneluaf, NULL);
	scenelua=(char*)malloc(sceneluas+1);
	memset(scenelua, 0, sceneluas+1);
	DWORD readin;
	ReadFile( sceneluaf, scenelua, sceneluas, &readin, NULL );
	CloseHandle( sceneluaf );

	if(setjmp( jmpbuffer )==0)
		lua_dobuffer(LUA_STATE, scenelua, sceneluas, "SCENE");

	return S_OK;
}

char cfgfilesearchpath[][64] = {
	"DVD:\\nexgen.cfg",
	"DVD:\\nexgen\\nexgen.cfg",
	"SYSTEM:\\nexgen.cfg",
	"SYSTEM:\\nexgen\\nexgen.cfg",
	"STORAGE:\\nexgen.cfg",
	"STORAGE:\\nexgen\\nexgen.cfg",
	"EXTENDED:\\nexgen.cfg",
	"EXTENDED:\\nexgen\\nexgen.cfg",
	"STORAGE:\\devkit\\nexgen\\nexgen.cfg",
	NULL
};

char cfgdatarealpath[][64] = {
	"\\Device\\Cdrom0",
	"\\Device\\Cdrom0\\nexgen",
	"\\Device\\Harddisk0\\Partition2",
	"\\Device\\Harddisk0\\Partition2\\nexgen",
	"\\Device\\Harddisk0\\Partition1",
	"\\Device\\Harddisk0\\Partition1\\nexgen",
	"\\Device\\Harddisk0\\Partition6",
	"\\Device\\Harddisk0\\Partition6\\nexgen",
	"\\Device\\Harddisk0\\Partition1\\devkit\\nexgen",
	NULL
};

char cfgskinrealpath[][64] = {
	"\\Device\\Cdrom0\\skins",
	"\\Device\\Cdrom0\\nexgen\\skins",
	"\\Device\\Harddisk0\\Partition2\\skins",
	"\\Device\\Harddisk0\\Partition2\\nexgen\\skins",
	"\\Device\\Harddisk0\\Partition1\\skins",
	"\\Device\\Harddisk0\\Partition1\\nexgen\\skins",
	"\\Device\\Harddisk0\\Partition6\\skins",
	"\\Device\\Harddisk0\\Partition6\\nexgen\\skins",
	"\\Device\\Harddisk0\\Partition1\\devkit\\nexgen\\skins",
	NULL
};

HRESULT CXBoxSample::LoadDefaults()
{
	int i;
	for(i=0; cfgfilesearchpath[i][0]; i++) {
		if(CheckFile(cfgfilesearchpath[i])==S_OK) {
			mappath(cfgdatarealpath[i], "DATA:");
			mappath(cfgskinrealpath[i], "SKINS:");
			LoadScene(cfgfilesearchpath[i]);
			return S_OK;
		}
	}

	return ERROR_FILE_NOT_FOUND;
}

HRESULT CXBoxSample::UnloadScene()
{
	lua_close(LUA_STATE);
	LUA_STATE=NULL;

	free(scenelua);
	scenelua=NULL;
	sceneluas=0;

	for(int i=0; i<128; i++) {
		if(sceneobjectlist[i].name != NULL) {
			sceneobjectlist[i].destroy(sceneobjectlist+i);
		}
		if(scenetxrlist[i].name != NULL) {
			free(scenetxrlist[i].name);
			scenetxrlist[i].name = NULL;
			if(scenetxrlist[i].data != NULL) {
				if(scenetxrlist[i].type==0)	scenetxrlist[i].data->Release();
				if(scenetxrlist[i].type==1) {
					free(scenetxrlist[i].data);
				}
				scenetxrlist[i].data = NULL;
			}
		}
	}

	m_pd3dDevice->Reset( &m_d3dpp );

	return S_OK;
}

HRESULT CXBoxSample::LoadNewScene()
{
	if(LUA_STATE!=NULL) UnloadScene();
	HRESULT rv=LoadScene(LOADNEWSCENE);
	return rv;
}

HRESULT CXBoxSample::FrameMove()
{
	char controlname[32];
	int i;
	while(LOADNEWSCENE!=NULL) LoadNewScene();

	if(LUA_STATE==NULL) return S_OK;

	//SoundTracks

	///

	//Needed For IR Support
	//XBOX IR Support finished off By SpOoK
	//Corrected Warning's Problem :)
	XBInput_GetInput( m_IR_Remote, m_fTime );
	ZeroMemory( &m_DefaultIR_Remote, sizeof(m_DefaultIR_Remote) );


	for( i=0; i<4; i++ )
	{
		if( m_IR_Remote[i].hDevice)
		{
						m_DefaultIR_Remote.wButtons        = m_IR_Remote[i].wButtons;
						m_DefaultIR_Remote.wPressedButtons = m_IR_Remote[i].wPressedButtons;
						m_DefaultIR_Remote.wLastButtons    = m_IR_Remote[i].wLastButtons;
		}
	}

	//Here's some quick Remote Buttons for Power and Reboot
	//Only added to check IR was working OK as well as the Power and Reboot Functions.
	if(m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_9)
	{
		m_xkutils.XBOXPowerOff();
	}
	else if(m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_0)
	{
		m_xkutils.XBOXReset();
	}
	else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK])
	{
		captureNumber++;
        systemScreenCapture(captureNumber);
	}
	//SoundTracks
	else if(m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE])
	{	
		g_AudioControl = !g_AudioControl;
	}
	int ControlState = 0;
	if (g_AudioControl) ControlState = 1;
	lua_pushnumber (LUA_STATE,ControlState);
	lua_setglobal(LUA_STATE,"AudioControl");
	//END SoundTracks

	strcpy(controlname, "cont");
	for(i=0; i<4; i++) {
		controlname[4]='A'+i;
		controlname[5]='x';
		controlname[6]=0;
		lua_pushnumber(LUA_STATE, g_Gamepads[i].fX1);
		lua_setglobal(LUA_STATE, controlname);
		controlname[5]='y';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].fY1);
		lua_setglobal(LUA_STATE, controlname);
		controlname[5]='r';
		controlname[6]='x';
		controlname[7]=0;
		lua_pushnumber(LUA_STATE, g_Gamepads[i].fX2);
		lua_setglobal(LUA_STATE, controlname);
		controlname[6]='y';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].fY2);
		lua_setglobal(LUA_STATE, controlname);

		strcpy(controlname+5, "pusha");
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_A] || m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_SELECT );
		lua_setglobal(LUA_STATE, controlname);
		controlname[9]='b';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_B] || m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_BACK );
		lua_setglobal(LUA_STATE, controlname);
		controlname[9]='x';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_X] );
		lua_setglobal(LUA_STATE, controlname);
		controlname[9]='y';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_Y] );
		lua_setglobal(LUA_STATE, controlname);
		controlname[9]='k';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_BLACK] );
		lua_setglobal(LUA_STATE, controlname);
		controlname[9]='w';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_WHITE] );
		lua_setglobal(LUA_STATE, controlname);
		controlname[9]='l';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] );
		lua_setglobal(LUA_STATE, controlname);
		controlname[9]='r';
		lua_pushnumber(LUA_STATE, g_Gamepads[i].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] );
		lua_setglobal(LUA_STATE, controlname);

        strcpy(controlname+9, "up");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_UP) || (m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_UP) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
        strcpy(controlname+9, "down");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_DOWN) || (m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_DOWN) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
        strcpy(controlname+9, "left");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_LEFT) || (m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_LEFT) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
        strcpy(controlname+9, "right");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_DPAD_RIGHT) || (m_DefaultIR_Remote.wPressedButtons == XINPUT_IR_REMOTE_RIGHT) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
        strcpy(controlname+9, "start");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_START) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
        strcpy(controlname+9, "back");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_BACK) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
        strcpy(controlname+9, "lthumb");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_LEFT_THUMB) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
        strcpy(controlname+9, "rthumb");
		lua_pushnumber(LUA_STATE, (g_Gamepads[i].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB) ? 1 : 0 );
		lua_setglobal(LUA_STATE, controlname);
	}

	if(!progressbar) {
		lua_getglobal(LUA_STATE, "framemove");
		lua_call(LUA_STATE, 0, 0);
	} else {
		lua_getglobal(LUA_STATE, "framemove_progress");
		lua_call(LUA_STATE, 0, 0);
	}

	//SoundTracks
	//if (g_WithAudio)
	DirectSoundDoWork();
    //m_pMusicManager->Process();
	m_pMusicManager->Play();

	return S_OK;
}

HRESULT CXBoxSample::Render()
{
	while(LOADNEWSCENE!=NULL) LoadNewScene();

	
    g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, 
                         D3DCOLOR_XRGB(0,0,0), 1.0f, 0L );
   
	if(LUA_STATE!=NULL) {
		// Setup the world, view, and projection matrices
		SetupMatrices();

		g_pd3dDevice->SetRenderState( D3DRS_LIGHTING,			TRUE );
		g_pd3dDevice->SetRenderState( D3DRS_AMBIENT,			0xffffffff );
		g_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE,	TRUE );

		g_pd3dDevice->GetTransform( D3DTS_WORLD, &matOriginalWorld );
		g_pd3dDevice->GetTransform( D3DTS_WORLD, &matSavedWorld );

		g_pd3dDevice->SetRenderState( D3DRS_BLENDOP,      D3DBLENDOP_ADD );
		g_pd3dDevice->SetRenderState( D3DRS_SRCBLEND,     D3DBLEND_CONSTANTALPHA );
		g_pd3dDevice->SetRenderState( D3DRS_DESTBLEND,    D3DBLEND_DESTCOLOR );
		g_pd3dDevice->SetRenderState( D3DRS_BLENDCOLOR, (0xcf<<24) );

		if(!progressbar) {
			lua_getglobal(LUA_STATE, "render");
			lua_call(LUA_STATE, 0, 0);
		} else {
			//lua_pushnumber(LUA_STATE, progressbar);
			//lua_setglobal(LUA_STATE, "progress");
			//lua_pushnumber(LUA_STATE, progressmax);
			//lua_setglobal(LUA_STATE, "progressmax");
			//lua_getglobal(LUA_STATE, "render_progress");
			lua_getglobal(LUA_STATE, "render");
			lua_call(LUA_STATE, 0, 0);
		}
	}

	g_pd3dDevice->SetRenderState( D3DRS_BLENDOP,			D3DBLENDOP_ADD );
	g_pd3dDevice->SetRenderState( D3DRS_SRCBLEND,			D3DBLEND_CONSTANTCOLOR );
	g_pd3dDevice->SetRenderState( D3DRS_DESTBLEND,			D3DBLEND_ZERO );
	scenefontlist[0].data.Begin();
	scenefontlist[0].data.DrawText(  65, 51, 0xff000000, L"neXgen Dashboard v1.0" );
	scenefontlist[0].data.DrawText(  64, 50, 0xffffffff, L"neXgen Dashboard v1.0" );
	scenefontlist[0].data.DrawText( 471, 51, 0xff000000, m_strFrameRate );
	scenefontlist[0].data.DrawText( 470, 50, 0xffffffff, m_strFrameRate );

	MEMORYSTATUS stat;
	GlobalMemoryStatus( &stat );

    WCHAR strOut[1024];
	wsprintfW(strOut, L"%4d MB of free physical memory.", stat.dwAvailPhys / (1024*1024) );
	scenefontlist[0].data.DrawText(  151, 66, 0xff000000, strOut );
	scenefontlist[0].data.DrawText(  150, 65, 0xffffffff, strOut );

	if(LUA_STATE==NULL) {
		scenefontlist[0].data.DrawText(  128, 220, 0xff000000, L"Please upload a configuration file" );
		scenefontlist[0].data.DrawText(  127, 220, 0xffffffff, L"Please upload a configuration file" );
		scenefontlist[0].data.DrawText(  180, 240, 0xff000000, L"and skin set using FTP." );
		scenefontlist[0].data.DrawText(  179, 240, 0xffffffff, L"and skin set using FTP." );
	}
	
	scenefontlist[0].data.End();
    
	g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
	return S_OK;
}

void __cdecl main()
{
    CXBoxSample xbApp;

	if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}


